// https://forex-station.com/viewtopic.php?p=1295478806#p1295478806
// https://forex-station.com/viewtopic.php?p=1295478883#p1295478883

#property indicator_chart_window

extern bool  Auto_Refresh               = TRUE;
extern int   Normal_TL_Period           = 500;
extern bool  Three_Touch                = TRUE;
extern bool  M1_Fast_Analysis           = TRUE;
extern bool  M5_Fast_Analysis           = TRUE;
extern bool  Mark_Highest_and_Lowest_TL = TRUE;
extern int   Expiration_Day_Alert       = 5;
extern color Normal_TL_Color            = clrGainsboro;
extern color Long_TL_Color              = clrGoldenrod;
extern int   Three_Touch_TL_Width       = 2;
extern color Three_Touch_TL_Color       = clrDimGray;

//Forex-Station button template start41; copy and paste
extern string             button_note1_          = "------------------------------";
extern int                btn_Subwindow         = 0;                               // What window to put the button on.  If <0, the button will use the same sub-window as the indicator.
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER;               // button corner on chart for anchoring
extern string             btn_text              = "TRUETL";                        // a button name
extern string             btn_Font              = "Arial";                         // button font name
extern int                btn_FontSize          = 9;                               // button font size               
extern color              btn_text_ON_color     = clrLime;                         // ON color when the button is turned on
extern color              btn_text_OFF_color    = clrRed;                          // OFF color when the button is turned off
extern color              btn_background_color  = clrDimGray;                      // background color of the button
extern color              btn_border_color      = clrBlack;                        // border color the button
extern int                button_x              = 20;                              // x coordinate of the button     
extern int                button_y              = 25;                              // y coordinate of the button     
extern int                btn_Width             = 80;                              // button width
extern int                btn_Height            = 20;                              // button height
extern string             button_note2          = "------------------------------";

bool show_data, recalc=false;
string IndicatorObjPrefix, buttonId;
//Forex-Station button template end41; copy and paste

int counted_bars;
//+------------------------------------------------------------------------------------------------------------------+
//Forex-Station button template start42; copy and paste
int OnInit()
{
   IndicatorDigits(Digits);
   IndicatorObjPrefix = "__" + btn_text + "__";
   
   // The leading "_" gives buttonId a *unique* prefix.  Furthermore, prepending the swin is usually unique unless >2+ of THIS indy are displayed in the SAME sub-window. (But, if >2 used, be sure to shift the buttonId position)
   buttonId = "_" + IndicatorObjPrefix + "_BT_";
   if (ObjectFind(buttonId)<0) 
      createButton(buttonId, btn_text, btn_Width, btn_Height, btn_Font, btn_FontSize, btn_background_color, btn_border_color, btn_text_ON_color);
   ObjectSetInteger(0, buttonId, OBJPROP_YDISTANCE, button_y);
   ObjectSetInteger(0, buttonId, OBJPROP_XDISTANCE, button_x);

   init2();

   show_data = ObjectGetInteger(0, buttonId, OBJPROP_STATE);
   
   if (show_data) ObjectSetInteger(0,buttonId,OBJPROP_COLOR,btn_text_ON_color); 
   else ObjectSetInteger(0,buttonId,OBJPROP_COLOR,btn_text_OFF_color);
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------------------------------------------------------+
void createButton(string buttonID,string buttonText,int width2,int height,string font,int fontSize,color bgColor,color borderColor,color txtColor)
{
      ObjectDelete    (0,buttonID);
      ObjectCreate    (0,buttonID,OBJ_BUTTON,btn_Subwindow,0,0);
      ObjectSetInteger(0,buttonID,OBJPROP_COLOR,txtColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,bgColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_COLOR,borderColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,width2);
      ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,height);
      ObjectSetString (0,buttonID,OBJPROP_FONT,font);
      ObjectSetString (0,buttonID,OBJPROP_TEXT,buttonText);
      ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,fontSize);
      ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,buttonID,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,buttonID,OBJPROP_HIDDEN,1);
      ObjectSetInteger(0,buttonID,OBJPROP_XDISTANCE,9999);
      ObjectSetInteger(0,buttonID,OBJPROP_YDISTANCE,9999);
      // Upon creation, set the initial state to "true" which is "on", so one will see the indicator by default
      ObjectSetInteger(0, buttonId, OBJPROP_STATE, true);
}
//+------------------------------------------------------------------------------------------------------------------+
void OnDeinit(const int reason) 
{
   // This 'ObjectsDeleteAll' is only needed when any objects *besides* the button are created, but this indicator does not, hence, not needed.
   //ObjectsDeleteAll(0, IndicatorObjPrefix);

   // If just changing a TF', the button need not be deleted, therefore the 'OBJPROP_STATE' is also preserved.
   if(reason != REASON_CHARTCHANGE) ObjectDelete(buttonId);
   deinit2();
}
//+------------------------------------------------------------------------------------------------------------------+
void OnChartEvent(const int id, //don't change anything here
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
   // If another indy on the same chart has enabled events for create/delete/mouse-move, just skip this events up front because they aren't
   //    needed, AND in the worst case, this indy might cause MT4 to hang!!  Skipping the events seems to help, along with other (major) changes to the code below.
   if(id==CHARTEVENT_OBJECT_CREATE || id==CHARTEVENT_OBJECT_DELETE) return; // This appears to make this indy compatible with other programs that enabled CHART_EVENT_OBJECT_CREATE and/or CHART_EVENT_OBJECT_DELETE
   if(id==CHARTEVENT_MOUSE_MOVE    || id==CHARTEVENT_MOUSE_WHEEL)   return; // If this, or another program, enabled mouse-events, these are not needed below, so skip it unless actually needed. 

   if (id==CHARTEVENT_OBJECT_CLICK && sparam == buttonId)
   {
      show_data = ObjectGetInteger(0, buttonId, OBJPROP_STATE);
      
      if (show_data)
      {
         ObjectSetInteger(0,buttonId,OBJPROP_COLOR,btn_text_ON_color); 
         init2();
          // Is it a problem to call 'start()' ??  Possibly it makes no difference, but now calling "mystart()" instead of "start()"; and "start()" simply runs "mystart()", so should be same as before.
         recalc=true;
         mystart();
      }
      else
      {
         ObjectSetInteger(0,buttonId,OBJPROP_COLOR,btn_text_OFF_color);
         deinit2();
      }
   }
}
//Forex-Station button template end42; copy and paste
//+------------------------------------------------------------------------------------------------------------------+
int init2() {
   ObjectCreate("calctl", OBJ_HLINE, 0, 0, 0);
   ObjectCreate("visibletl", OBJ_HLINE, 0, 0, 0);
   ObjectCreate("downmax", OBJ_TREND, 0, 0, 0, 0, 0);
   ObjectCreate("upmax", OBJ_TREND, 0, 0, 0, 0, 0);
   return (0);
}
//+------------------------------------------------------------------------------------------------------------------+
int deinit2() {
   for (int ForexStation = 0; ForexStation <= 100; ForexStation++) {
      ObjectDelete("downtrendline" + ForexStation);
      ObjectDelete("uptrendline" + ForexStation);
      ObjectDelete("downtrendline" + ForexStation + "tt");
      ObjectDelete("uptrendline" + ForexStation + "tt");
   }
   ObjectDelete("calctl");
   ObjectDelete("timeleft");
   ObjectDelete("invacc");
   ObjectDelete("visibletl");
   ObjectDelete("downmax");
   ObjectDelete("upmax");
   ObjectDelete("downmax");
   ObjectDelete("upmax");
   return (0);
}
//+------------------------------------------------------------------------------------------------------------------+
int start() {return(mystart()); }
//+------------------------------------------------------------------------------------------------------------------+
int mystart()
  {
   if (show_data)
      {
   double mySecondCount;
   double myFractal01;
   double CandleHigh;
   double SemaFor01;
   double myFractal02;
   double AnotherCandleHigh;
   double myTemp01;
   double DownLine;
   double AlternatePoint;
   double TouchDownLine01;
   double Touch3Shift;
   double NormalTL;
   double Forex01;
   double MachNumber;
   double MandoNumber;
   double anotherDownLine01;
   double anotherDownLine02;
   double TempDownLine02;
   double TempDownLine;
   double myATRnumber;
   double MagicNumber;
   double yourDownTrendLine02;
   double yourUpTrendLine02;
   if (Normal_TL_Period > 1000 || Normal_TL_Period < 100) Normal_TL_Period = 500;
   string myAccount01 = AccountNumber();
   string myAccount02 = AccountNumber();
   int myGoal = 1;

   int myVisibleBar = MathMax(0, WindowFirstVisibleBar() - WindowBarsPerChart());
   double limit = Bars;

   if (counted_bars == 0) counted_bars = limit;
        if(recalc) 
        {
           // If a button goes from off-to-on, everything must be recalculated.  The 'recalc' variable is used as a trigger to do this.
           counted_bars = 0;
           recalc=false;
        }

   if (limit > counted_bars) {
      counted_bars = limit;
      if (Auto_Refresh == TRUE && myVisibleBar == 0) ObjectSet("calctl", OBJPROP_PRICE1, -1);
   }
   if (Auto_Refresh == TRUE && IndicatorCounted() == 0) ObjectSet("calctl", OBJPROP_PRICE1, -1);
   if (ObjectGet("visibletl", OBJPROP_PRICE1) == -1.0) {
      for (int myDownTrendLine = 0; myDownTrendLine <= 100; myDownTrendLine++) {
         ObjectDelete("downtrendline" + myDownTrendLine);
         ObjectDelete("uptrendline" + myDownTrendLine);
         ObjectDelete("downtrendline" + myDownTrendLine + "tt");
         ObjectDelete("uptrendline" + myDownTrendLine + "tt");
      }
   }
   if (ObjectGet("calctl", OBJPROP_PRICE1) == -1.0 && ObjectGet("visibletl", OBJPROP_PRICE1) == 0.0 && StringFind(myAccount02, myAccount01, 0) >= 0 && myGoal > 0) {
      for (myDownTrendLine = 0; myDownTrendLine <= 100; myDownTrendLine++) {
         ObjectDelete("downtrendline" + myDownTrendLine);
         ObjectDelete("uptrendline" + myDownTrendLine);
         ObjectDelete("downtrendline" + myDownTrendLine + "tt");
         ObjectDelete("uptrendline" + myDownTrendLine + "tt");
      }
      mySecondCount = 150000;
      if (Period() == PERIOD_M1 && M1_Fast_Analysis == TRUE) mySecondCount = 8000;
      if (Period() == PERIOD_M5 && M5_Fast_Analysis == TRUE) mySecondCount = 2400;
      if (Period() == PERIOD_MN1) {
         mySecondCount = 150;
         Three_Touch = FALSE;
         Normal_TL_Period = 150;
      }
      myFractal01 = myVisibleBar + MathMin(Bars - myVisibleBar - 10, mySecondCount);
      CandleHigh = iHigh(NULL, 0, myFractal01);
      myFractal02 = myVisibleBar + MathMin(Bars - myVisibleBar - 10, mySecondCount);
      AnotherCandleHigh = iHigh(NULL, 0, myFractal02);
      for (int kounter01 = 1; kounter01 < 50; kounter01++) {
         if ((iFractals(NULL, 0, MODE_UPPER, myVisibleBar + kounter01) > 0.0 && kounter01 > 2) || (Close[myVisibleBar + kounter01 + 1] > Open[myVisibleBar + kounter01 + 1] && Close[myVisibleBar + kounter01 + 1] - (Low[myVisibleBar +
            kounter01 + 1]) < 0.6 * (High[myVisibleBar + kounter01 + 1] - (Low[myVisibleBar + kounter01 + 1])) && Close[myVisibleBar + kounter01] < Open[myVisibleBar + kounter01]) || (Close[myVisibleBar + kounter01 + 1] <= Open[myVisibleBar +
            kounter01 + 1] && Close[myVisibleBar + kounter01] < Open[myVisibleBar + kounter01]) || (Close[myVisibleBar + kounter01] < Open[myVisibleBar + kounter01] && Close[myVisibleBar + kounter01] < Low[myVisibleBar + kounter01 + 1])) {
            SemaFor01 = myVisibleBar + kounter01;
            break;
         }
      }
      for (int kounter02 = 1; kounter02 <= 30; kounter02++) {
         if (myFractal01 > SemaFor01 + 6.0) {
            ObjectCreate("downtrendline" + kounter02, OBJ_TREND, 0, iTime(NULL, 0, myFractal01), CandleHigh, iTime(NULL, 0, myFractal01), CandleHigh);
            for (kounter01 = myFractal01; kounter01 >= SemaFor01; kounter01--) {
               if (ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE1) == ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE2)) {
                  ObjectMove("downtrendline" + kounter02, 1, iTime(NULL, 0, kounter01 - 1), iHigh(NULL, 0, kounter01 - 1));
                  myFractal01 = kounter01 - 1;
                  CandleHigh = iHigh(NULL, 0, kounter01 - 1);
               }
               DownLine = ObjectGetValueByShift("downtrendline" + kounter02, kounter01);
               if (DownLine < iHigh(NULL, 0, kounter01)) {
                  ObjectMove("downtrendline" + kounter02, 1, iTime(NULL, 0, kounter01), iHigh(NULL, 0, kounter01));
                  myFractal01 = kounter01;
                  CandleHigh = iHigh(NULL, 0, kounter01);
               }
            }
         }
         if (ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE1) < ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE2)) ObjectDelete("downtrendline" + kounter02);
         if (iBarShift(NULL, 0, ObjectGet("downtrendline" + kounter02, OBJPROP_TIME1)) - myVisibleBar >= Normal_TL_Period) {
            ObjectSet("downtrendline" + kounter02, OBJPROP_COLOR, Long_TL_Color);
            ObjectSetText("downtrendline" + kounter02, "Long");
         } else {
            ObjectSet("downtrendline" + kounter02, OBJPROP_COLOR, Normal_TL_Color);
            ObjectSetText("downtrendline" + kounter02, "Normal");
         }
      }
      for (kounter01 = 1; kounter01 < 50; kounter01++) {
         if ((iFractals(NULL, 0, MODE_LOWER, myVisibleBar + kounter01) > 0.0 && kounter01 > 2) || (Close[myVisibleBar + kounter01 + 1] < Open[myVisibleBar + kounter01 + 1] && High[myVisibleBar + kounter01 + 1] - (Close[myVisibleBar +
            kounter01 + 1]) < 0.6 * (High[myVisibleBar + kounter01 + 1] - (Low[myVisibleBar + kounter01 + 1])) && Close[myVisibleBar + kounter01] > Open[myVisibleBar + kounter01]) || (Close[myVisibleBar + kounter01 + 1] >= Open[myVisibleBar +
            kounter01 + 1] && Close[myVisibleBar + kounter01] > Open[myVisibleBar + kounter01]) || (Close[myVisibleBar + kounter01] > Open[myVisibleBar + kounter01] && Close[myVisibleBar + kounter01] > High[myVisibleBar + kounter01 + 1])) {
            myTemp01 = myVisibleBar + kounter01;
            break;
         }
      }
      for (kounter02 = 1; kounter02 <= 30; kounter02++) {
         if (myFractal02 > myTemp01 + 6.0) {
            ObjectCreate("uptrendline" + kounter02, OBJ_TREND, 0, iTime(NULL, 0, myFractal02), AnotherCandleHigh, iTime(NULL, 0, myFractal02), AnotherCandleHigh);
            for (kounter01 = myFractal02; kounter01 >= myTemp01; kounter01--) {
               if (ObjectGet("uptrendline" + kounter02, OBJPROP_TIME1) == ObjectGet("uptrendline" + kounter02, OBJPROP_TIME2)) {
                  ObjectMove("uptrendline" + kounter02, 1, iTime(NULL, 0, kounter01 - 1), iLow(NULL, 0, kounter01 - 1));
                  myFractal02 = kounter01 - 1;
                  AnotherCandleHigh = iLow(NULL, 0, kounter01 - 1);
               }
               DownLine = ObjectGetValueByShift("uptrendline" + kounter02, kounter01);
               if (iLow(NULL, 0, kounter01) < DownLine) {
                  ObjectMove("uptrendline" + kounter02, 1, iTime(NULL, 0, kounter01), iLow(NULL, 0, kounter01));
                  myFractal02 = kounter01;
                  AnotherCandleHigh = iLow(NULL, 0, kounter01);
               }
            }
         }
         if (ObjectGet("uptrendline" + kounter02, OBJPROP_PRICE1) > ObjectGet("uptrendline" + kounter02, OBJPROP_PRICE2)) ObjectDelete("uptrendline" + kounter02);
         if (iBarShift(NULL, 0, ObjectGet("uptrendline" + kounter02, OBJPROP_TIME1)) - myVisibleBar >= Normal_TL_Period) {
            ObjectSet("uptrendline" + kounter02, OBJPROP_COLOR, Long_TL_Color);
            ObjectSetText("uptrendline" + kounter02, "Long");
         } else {
            ObjectSet("uptrendline" + kounter02, OBJPROP_COLOR, Normal_TL_Color);
            ObjectSetText("uptrendline" + kounter02, "Normal");
         }
      }
      if (Three_Touch == TRUE && Bars > 1000) {
         for (kounter02 = 1; kounter02 <= 30; kounter02++) {
            TouchDownLine01 = ObjectGet("downtrendline" + kounter02, OBJPROP_TIME1);
            Touch3Shift = iBarShift(NULL, 0, TouchDownLine01);
            AlternatePoint = SemaFor01;
            NormalTL = Touch3Shift - AlternatePoint;
            if (NormalTL < MathMin(Normal_TL_Period, 1000) && NormalTL > 6.0) {
               ObjectCreate("downtrendline" + kounter02 + "tt", OBJ_TREND, 0, iTime(NULL, 0, Touch3Shift), iHigh(NULL, 0, Touch3Shift), iTime(NULL, 0, AlternatePoint), iHigh(NULL, 0, AlternatePoint));
               ObjectSet("downtrendline" + kounter02 + "tt", OBJPROP_WIDTH, 2);
               myATRnumber = iATR(NULL, 0, NormalTL, myVisibleBar) / Point / 10.0;
               MagicNumber = 8.0 * myATRnumber;
               Forex01 = 0;
               MachNumber = 0;
               MandoNumber = 0;
               for (int kounter200 = AlternatePoint; kounter200 <= Touch3Shift; kounter200++) {
                  if (MachNumber == 0.0 && MandoNumber >= 3.0 && kounter200 > AlternatePoint) {
                     TempDownLine02 = 0;
                     TempDownLine = ObjectGet("downtrendline" + kounter02 + "tt", OBJPROP_PRICE2);
                     for (int kounter1000 = 1; kounter1000 <= 5; kounter1000++) {
                        if (TempDownLine02 >= 3.0) Forex01 = 1;
                        if (Forex01 == 0.0) {
                           ObjectSet("downtrendline" + kounter02 + "tt", OBJPROP_PRICE2, TempDownLine + (kounter1000 - 3) * Point);
                           TempDownLine02 = 0;
                           for (int kounter2000 = AlternatePoint; kounter2000 <= Touch3Shift; kounter2000++) {
                              DownLine = ObjectGetValueByShift("downtrendline" + kounter02 + "tt", kounter2000);
                              if (DownLine + myATRnumber * Point > iHigh(NULL, 0, kounter2000) && DownLine - myATRnumber * Point < iHigh(NULL, 0, kounter2000)) {
                                 TempDownLine02++;
                                 kounter2000++;
                              }
                           }
                        }
                     }
                  }
                  if (Forex01 == 0.0 && kounter200 == Touch3Shift) ObjectDelete("downtrendline" + kounter02 + "tt");
                  if (Forex01 == 1.0 && kounter200 == Touch3Shift) {
                     anotherDownLine01 = ObjectGetValueByShift("downtrendline" + kounter02, AlternatePoint);
                     anotherDownLine02 = ObjectGetValueByShift("downtrendline" + kounter02 + "tt", AlternatePoint);
                     if (MathAbs(anotherDownLine01 - anotherDownLine02) > MagicNumber * Point) ObjectDelete("downtrendline" + kounter02 + "tt");
                  }
                  if (Forex01 == 0.0 && kounter200 <= Touch3Shift) ObjectMove("downtrendline" + kounter02 + "tt", 1, iTime(NULL, 0, kounter200), iHigh(NULL, 0, kounter200));
                  if (Forex01 == 0.0) {
                     MachNumber = 0;
                     MandoNumber = 0;
                     for (kounter01 = AlternatePoint; kounter01 <= Touch3Shift; kounter01++) {
                        DownLine = ObjectGetValueByShift("downtrendline" + kounter02 + "tt", kounter01);
                        if (iClose(NULL, 0, kounter01) > ObjectGetValueByShift("downtrendline" + kounter02 + "tt", kounter01)) MachNumber++;
                        if (DownLine + 2.0 * myATRnumber * Point > iHigh(NULL, 0, kounter01) && DownLine - 2.0 * myATRnumber * Point < iHigh(NULL, 0, kounter01)) {
                           MandoNumber++;
                           kounter01++;
                        }
                     }
                  }
               }
            }
         }
         for (kounter02 = 1; kounter02 <= 30; kounter02++) {
            TouchDownLine01 = ObjectGet("uptrendline" + kounter02, OBJPROP_TIME1);
            Touch3Shift = iBarShift(NULL, 0, TouchDownLine01);
            AlternatePoint = myTemp01;
            NormalTL = Touch3Shift - AlternatePoint;
            if (NormalTL < MathMin(Normal_TL_Period, 1000) && NormalTL > 6.0) {
               ObjectCreate("uptrendline" + kounter02 + "tt", OBJ_TREND, 0, iTime(NULL, 0, Touch3Shift), iLow(NULL, 0, Touch3Shift), iTime(NULL, 0, Touch3Shift), iLow(NULL, 0, Touch3Shift));
               ObjectSet("uptrendline" + kounter02 + "tt", OBJPROP_WIDTH, 2);
               myATRnumber = iATR(NULL, 0, NormalTL, myVisibleBar) / Point / 10.0;
               MagicNumber = 8.0 * myATRnumber;
               Forex01 = 0;
               MandoNumber = 0;
               for (kounter200 = AlternatePoint; kounter200 <= Touch3Shift; kounter200++) {
                  if (MachNumber == 0.0 && MandoNumber >= 3.0 && kounter200 > AlternatePoint && Forex01 == 0.0) {
                     TempDownLine02 = 0;
                     TempDownLine = ObjectGet("uptrendline" + kounter02 + "tt", OBJPROP_PRICE2);
                     for (kounter1000 = 1; kounter1000 <= 5; kounter1000++) {
                        if (TempDownLine02 >= 3.0) Forex01 = 1;
                        if (Forex01 == 0.0) {
                           ObjectSet("uptrendline" + kounter02 + "tt", OBJPROP_PRICE2, TempDownLine + (kounter1000 - 3) * Point);
                           TempDownLine02 = 0;
                           for (kounter2000 = AlternatePoint; kounter2000 <= Touch3Shift; kounter2000++) {
                              DownLine = ObjectGetValueByShift("uptrendline" + kounter02 + "tt", kounter2000);
                              if (DownLine + myATRnumber * Point > iLow(NULL, 0, kounter2000) && DownLine - myATRnumber * Point < iLow(NULL, 0, kounter2000)) {
                                 TempDownLine02++;
                                 kounter2000++;
                              }
                           }
                        }
                     }
                  }
                  if (Forex01 == 0.0 && kounter200 == Touch3Shift) ObjectDelete("uptrendline" + kounter02 + "tt");
                  if (Forex01 == 1.0 && kounter200 == Touch3Shift) {
                     anotherDownLine01 = ObjectGetValueByShift("uptrendline" + kounter02, AlternatePoint);
                     anotherDownLine02 = ObjectGetValueByShift("uptrendline" + kounter02 + "tt", AlternatePoint);
                     if (MathAbs(anotherDownLine01 - anotherDownLine02) > MagicNumber * Point) ObjectDelete("uptrendline" + kounter02 + "tt");
                  }
                  if (Forex01 == 0.0 && kounter200 < Touch3Shift) ObjectMove("uptrendline" + kounter02 + "tt", 1, iTime(NULL, 0, kounter200), iLow(NULL, 0, kounter200));
                  if (Forex01 == 0.0) {
                     MachNumber = 0;
                     MandoNumber = 0;
                     for (kounter01 = AlternatePoint; kounter01 <= Touch3Shift; kounter01++) {
                        DownLine = ObjectGetValueByShift("uptrendline" + kounter02 + "tt", kounter01);
                        if (iClose(NULL, 0, kounter01) < ObjectGetValueByShift("uptrendline" + kounter02 + "tt", kounter01)) MachNumber++;
                        if (DownLine + 2.0 * myATRnumber * Point > iLow(NULL, 0, kounter01) && DownLine - 2.0 * myATRnumber * Point < iLow(NULL, 0, kounter01)) {
                           MandoNumber++;
                           kounter01++;
                        }
                     }
                  }
               }
            }
         }
         for (kounter01 = 0; kounter01 <= 30; kounter01++) {
            if (ObjectGetValueByShift("uptrendline" + kounter01 + "tt", myVisibleBar + 1) > 0.0) {
               ObjectSet("uptrendline" + kounter01, OBJPROP_WIDTH, Three_Touch_TL_Width);
               ObjectSet("uptrendline" + kounter01, OBJPROP_COLOR, Three_Touch_TL_Color);
               ObjectSetText("uptrendline" + kounter01, "3t");
               ObjectDelete("uptrendline" + kounter01 + "tt");
            }
         }
         for (kounter01 = 0; kounter01 <= 30; kounter01++) {
            if (ObjectGetValueByShift("downtrendline" + kounter01 + "tt", myVisibleBar + 1) > 0.0) {
               ObjectSet("downtrendline" + kounter01, OBJPROP_WIDTH, Three_Touch_TL_Width);
               ObjectSet("downtrendline" + kounter01, OBJPROP_COLOR, Three_Touch_TL_Color);
               ObjectSetText("downtrendline" + kounter01, "3t");
               ObjectDelete("downtrendline" + kounter01 + "tt");
            }
         }
      }
      for (kounter02 = 0; kounter02 <= 30; kounter02++) {
         if (ObjectGet("downtrendline" + ((kounter02 - 1)), OBJPROP_PRICE1) == 0.0 && ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE1) > 0.0 && Mark_Highest_and_Lowest_TL == TRUE) {
            ObjectSet("downmax", OBJPROP_TIME1, iTime(NULL, 0, myVisibleBar + 6));
            ObjectSet("downmax", OBJPROP_PRICE1, ObjectGetValueByShift("downtrendline" + kounter02, myVisibleBar + 6));
            ObjectSet("downmax", OBJPROP_TIME2, iTime(NULL, 0, myVisibleBar + 3));
            ObjectSet("downmax", OBJPROP_PRICE2, ObjectGetValueByShift("downtrendline" + kounter02, myVisibleBar + 3));
            ObjectSet("downmax", OBJPROP_COLOR, ObjectGet("downtrendline" + kounter02, OBJPROP_COLOR));
            ObjectSet("downmax", OBJPROP_WIDTH, 5);
            ObjectSet("downmax", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("downmax", OBJPROP_RAY, FALSE);
            ObjectSet("downmax", OBJPROP_BACK, TRUE);
         }
         if (ObjectGet("uptrendline" + ((kounter02 - 1)), OBJPROP_PRICE1) == 0.0 && ObjectGet("uptrendline" + kounter02, OBJPROP_PRICE1) > 0.0 && Mark_Highest_and_Lowest_TL == TRUE) {
            ObjectSet("upmax", OBJPROP_TIME1, iTime(NULL, 0, myVisibleBar + 6));
            ObjectSet("upmax", OBJPROP_PRICE1, ObjectGetValueByShift("uptrendline" + kounter02, myVisibleBar + 6));
            ObjectSet("upmax", OBJPROP_TIME2, iTime(NULL, 0, myVisibleBar + 3));
            ObjectSet("upmax", OBJPROP_PRICE2, ObjectGetValueByShift("uptrendline" + kounter02, myVisibleBar + 3));
            ObjectSet("upmax", OBJPROP_COLOR, ObjectGet("uptrendline" + kounter02, OBJPROP_COLOR));
            ObjectSet("upmax", OBJPROP_WIDTH, 5);
            ObjectSet("upmax", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("upmax", OBJPROP_RAY, FALSE);
            ObjectSet("upmax", OBJPROP_BACK, TRUE);
         }
      }
      yourDownTrendLine02 = 0;
      yourUpTrendLine02 = 0;
      for (kounter02 = 1; kounter02 <= 30; kounter02++) {
         yourDownTrendLine02 += ObjectGet("downtrendline" + kounter02, OBJPROP_PRICE1);
         yourUpTrendLine02 += ObjectGet("uptrendline" + kounter02, OBJPROP_PRICE1);
      }
      if (yourDownTrendLine02 == 0.0) {
         ObjectSet("downmax", OBJPROP_TIME1, 0);
         ObjectSet("downmax", OBJPROP_PRICE1, 0);
         ObjectSet("downmax", OBJPROP_TIME2, 0);
         ObjectSet("downmax", OBJPROP_PRICE2, 0);
      }
      if (yourUpTrendLine02 == 0.0) {
         ObjectSet("upmax", OBJPROP_TIME1, 0);
         ObjectSet("upmax", OBJPROP_PRICE1, 0);
         ObjectSet("upmax", OBJPROP_TIME2, 0);
         ObjectSet("upmax", OBJPROP_PRICE2, 0);
      }
      ObjectSet("calctl", OBJPROP_PRICE1, 0);
   }
       } //if (show_data)  
   return (0);
}